# SynchroDev Backend API

Backend API para el sitio web de SynchroDev, desarrollado con Express.js para manejar el envío de correos electrónicos del formulario de contacto.

## 🚀 Características

- **Envío de emails**: Manejo del formulario de contacto con confirmación automática
- **Seguridad**: Rate limiting, validación de datos, CORS configurado
- **Validaciones**: Validación robusta de todos los campos del formulario
- **Templates HTML**: Emails con diseño profesional y responsive
- **Logging**: Sistema de logs para monitoreo y debugging
- **Variables de entorno**: Configuración segura mediante archivos .env

## 📋 Requisitos

- Node.js >= 16.0.0
- npm o yarn
- Servidor de email SMTP configurado

## 🛠️ Instalación

1. **Instalar dependencias**:
   ```bash
   npm install
   ```

2. **Configurar variables de entorno**:
   Crear archivo `.env` en la raíz del proyecto:
   ```env
   PORT=5000
   NODE_ENV=production
   
   EMAIL_HOST=mail.synchrodev.cl
   EMAIL_PORT=465
   EMAIL_USER=no-reply@synchrodev.cl
   EMAIL_PASS=tu_password_aqui
   EMAIL_SECURE=true
   
   CONTACT_EMAIL=contacto@synchrodev.cl
   FRONTEND_URL=http://localhost:3001
   ```

3. **Iniciar el servidor**:
   ```bash
   # Desarrollo
   npm run dev
   
   # Producción
   npm start
   ```

## 📡 API Endpoints

### GET /health
Verifica el estado del servidor.

**Respuesta**:
```json
{
  "status": "OK",
  "message": "Servidor funcionando correctamente",
  "timestamp": "2025-01-XX...",
  "environment": "production"
}
```

### POST /api/contact
Envía un email de contacto.

**Body**:
```json
{
  "nombre": "Juan Pérez",
  "email": "juan@ejemplo.com",
  "telefono": "+56912345678", // Opcional
  "empresa": "Mi Empresa", // Opcional
  "mensaje": "Mensaje de contacto..."
}
```

**Respuesta exitosa**:
```json
{
  "success": true,
  "message": "Mensaje enviado exitosamente. Te responderemos pronto.",
  "timestamp": "2025-01-XX..."
}
```

**Respuesta de error**:
```json
{
  "success": false,
  "message": "Datos de entrada inválidos",
  "errors": [
    {
      "field": "email",
      "message": "Debe proporcionar un email válido"
    }
  ]
}
```

## 🔒 Seguridad

- **Rate Limiting**: Máximo 5 emails por IP cada 15 minutos
- **Helmet**: Headers de seguridad HTTP
- **CORS**: Configurado para permitir solo el frontend autorizado
- **Validación**: Validación estricta de todos los campos de entrada
- **Sanitización**: Limpieza automática de datos de entrada

## 📧 Configuración de Email

El sistema envía dos emails por cada contacto:

1. **Email a SynchroDev**: Notificación del nuevo mensaje con toda la información
2. **Email de confirmación**: Confirmación automática al cliente

Ambos emails incluyen:
- Diseño HTML responsive
- Información completa del contacto
- Timestamp con zona horaria de Chile
- Enlaces a redes sociales (en email de confirmación)

## 🚀 Despliegue

### Variables de entorno para producción:
```env
NODE_ENV=production
PORT=5000
FRONTEND_URL=https://tu-dominio.com
```

### Comandos de despliegue:
```bash
# Instalar dependencias de producción
npm ci --only=production

# Iniciar servidor
npm start
```

## 📝 Logs

El servidor registra:
- Errores de envío de email
- Intentos de rate limiting
- Errores de validación
- Estado del servidor

## 🧪 Testing

Para probar el endpoint de contacto:

```bash
curl -X POST http://localhost:5000/api/contact \
  -H "Content-Type: application/json" \
  -d '{
    "nombre": "Test User",
    "email": "test@ejemplo.com",
    "mensaje": "Este es un mensaje de prueba"
  }'
```

## 📦 Dependencias

- **express**: Framework web
- **cors**: Manejo de CORS
- **helmet**: Seguridad HTTP
- **express-rate-limit**: Rate limiting
- **express-validator**: Validación de datos
- **nodemailer**: Envío de emails
- **dotenv**: Variables de entorno

## 🤝 Contribución

1. Fork el proyecto
2. Crea una rama para tu feature (`git checkout -b feature/AmazingFeature`)
3. Commit tus cambios (`git commit -m 'Add some AmazingFeature'`)
4. Push a la rama (`git push origin feature/AmazingFeature`)
5. Abre un Pull Request

## 📄 Licencia

Este proyecto está bajo la Licencia MIT - ver el archivo [LICENSE](LICENSE) para detalles.

---

**SynchroDev** - *Sincronizando las nuevas tecnologías*